/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.apache.hyracks.control.common.controllers.ServiceConstants;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownNCServiceWork
extends SynchronizableWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String ncHost;
    private final int ncPort;
    private final String ncId;

    public ShutdownNCServiceWork(String ncHost, int ncPort, String ncId) {
        this.ncHost = ncHost;
        this.ncPort = ncPort;
        this.ncId = ncId;
    }

    public final void doRun() {
        LOGGER.info("Connecting to NC service '" + this.ncId + "' at " + this.ncHost + ":" + this.ncPort);
        try (Socket s = new Socket(this.ncHost, this.ncPort);){
            ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
            oos.writeUTF("hyncmagic2");
            oos.writeUTF(ServiceConstants.ServiceCommand.TERMINATE.name());
            oos.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARN, "Failed to contact NC service '" + this.ncId + "' at " + this.ncHost + ":" + this.ncPort, (Throwable)e);
        }
    }
}

