/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.aries.cdi.container.internal.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Throw {

	private Throw() {
		// no instances
	}

	public static <T> T exception(Throwable throwable) {
		return Throw.<T, RuntimeException>_exception(throwable);
	}

	@SuppressWarnings("unchecked")
	private static <T, E extends Throwable> T _exception(Throwable throwable) throws E {
		throw (E)throwable;
	}

	public static String asString(Throwable t) {
		StringWriter sw = new StringWriter();
		t.printStackTrace(new PrintWriter(sw));
		return sw.toString();
	}

}